package gov.va.vinci.dart;

import gov.va.vinci.dart.usr.CustomAuthentication;
import gov.va.vinci.dart.usr.UserPreferences;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * The base class for all DART controllers. The static member variables are initialized
 * by the AppPropertiesProcessor class.
 */
public abstract class DartController {

	private static boolean debugMode = false;
	
	private static String indexPage = null;
	private static String reportingPage = null;
	
	
	protected UserPreferences getUserPreferences() {
		return ((CustomAuthentication)SecurityContextHolder.getContext().getAuthentication()).getUserPreferences();
	}

	public static boolean isDebugMode() {
		return debugMode;
	}
	
    public static void setDebugMode(boolean debugMode) {
        DartController.debugMode = debugMode;
    }

	public static String getIndexPage() {
		return indexPage;
	}
	
    public static void setIndexPage(String indexPage) {
        DartController.indexPage = indexPage;
    }
    
    public static String getReportingPage() {
        return reportingPage;
    }
    
    public static void setReportingPage(String reportingPage) {
        DartController.reportingPage = reportingPage;
    }
}
